#include "main.h"

list<_shot> eshot;
list<_enemy> enemies;

void _enemy::init(int _type, int _delay)
{
	int a;
	switch (_type)
	{
		case ECIRCLE:
			a = rand()%2;
			if (a == 0)
			{
				init(ECIRCLE, 40 + rand()%200, -20, STRAFERIGHT, _delay);
			}
			else
			{
				init(ECIRCLE, 400 + rand()%200, -20, STRAFELEFT, _delay);
			}
			break;
		case ESHIP:
			a = rand()%2;
			if (a == 0)
			{
				init(ESHIP, rand()%200, -20, CURVERIGHT, _delay);
			}
			else
			{
				init(ESHIP, 440 + rand()%200, -20, CURVELEFT, _delay);
			}
			break;
		case ESAUCER:
			a = rand()%2;
			if (a == 0)
			{
				init(ESAUCER, -20, 20 + rand()%350, SINERIGHT, _delay);
			}
			else
			{
				init(ESAUCER, 660, 20 + rand()%350, SINELEFT, _delay);
			}
			break;
	}
}

void _enemy::init(int _type, float _x, float _y, int _pattern, int _delay)
{
	exists = true;
	delay = _delay;
	type = _type;
	orig_x = x = _x;
	orig_y = y = _y;
	pattern = _pattern;
	xv = yv = xa = ya = shotdelay = 0;
	
	switch(pattern)
	{
		case STRAFELEFT:
			yv = 4;
			xv = -2;
			break;
		case STRAFERIGHT:
			yv = 4;
			xv = 2;
			break;
		case CURVELEFT:
			yv = 5 + rand()%3;
			xv = -1;
			ya = 0;
			xa = -0.25;
			break;
		case CURVERIGHT:
			yv = 5 + rand()%3;
			xv = 1;
			ya = 0;
			xa = 0.25;
			break;
		case SINELEFT:
			xv = -5;
			break;
		case SINERIGHT:
			xv = 5;
			break;
		case SINEDOWN:
			yv = 5;
			break;
	}
}

void _enemy::move()
{
	switch(pattern)
	{
		case STRAFELEFT:
		case STRAFERIGHT:
			x += xv;
			y += yv;
			break;
		case CURVELEFT:
		case CURVERIGHT:
			x += xv;
			y += yv;
			xv += xa;
			yv += ya;
			break;
		case SINELEFT:
		case SINERIGHT:
			x += xv;
			y = orig_y + 50 * sin(x * PI / 180);
			break;
		case SINEDOWN:
			y += yv;
			x = orig_x + 50 * sin(y * PI / 180);
			break;
	}
}

void _enemy::do_stuff()
{
	int d = 0;
	int s;
	
	if (delay > 0)
	{
		delay--;
		return;
	}
	
	if ((x < -50) || (y < -50) || (x > 690) || (y > 530))
	{
		exists = 0;
	}
	
	if (collided_with_player())
	{
		exists = 0;
		switch(type)
		{
			case ECIRCLE:
				d = 12;
				break;
			default:
				d = 15;
		}
		new_particle(P_EXPLODE, int(x), int(y), xv, yv);
		play_sample(ssmallboom, 255, 128, 1000, 0);
		player.take_damage(d);
	}
	else if (was_shot())
	{
		exists = 0;
		new_particle(P_EXPLODE, int(x), int(y), xv, yv);
		if (player.insane)
		{
			play_sample(scrazylaugh, 255, 128, 1000, 0);
		}
		else
		{
			play_sample(ssmallboom, 255, 128, 1000, 0);
		}
		
		s = level;
		switch(type)
		{
			case ECIRCLE:
				s *= 2;
				break;
			case ESHIP:
				s *= 3;
				break;
			case ESAUCER:
				s *= 5;
				break;
		}
		if (player.insane) s /= 2;
		score += s;
		if (score > highscore) highscore = score;
	}
	
	if (shotdelay <= 0)
	{
		fire();
		shotdelay = 70;
	}
	else
	{
		shotdelay--;
	}
	
	move();
	draw();
}

void _enemy::fire()
{
	float speed;
	float angle = atan2(player.y - y, player.x - x);
	_shot s;
	
	switch (type)
	{
		case ECIRCLE:
			speed = 6;
			break;
		case ESHIP:
			speed = 7;
			break;
		default:
			speed = 6;
			break;
	}
	
	s.x = x + 10;
	s.y = y + 10;
	s.xv = speed * cos(angle);
	s.yv = speed * sin(angle);
	eshot.push_back(s);
}

void _enemy::draw()
{
	int i = SANE;
	if (player.insane)
	{
		i = CRAZY;
	}
	
	switch (type)
	{
		case ECIRCLE:
			buffer_rotate_sprite(enemy1[i], int(x), int(y), ftofix((atan2(yv, xv)) * 128 / PI - 64));
			break;
		case ESHIP:
			buffer_rotate_sprite(enemy2[i], int(x), int(y), ftofix((atan2(yv, xv)) * 128 / PI - 64));
			break;
		case ESAUCER:
			buffer_draw_sprite(enemy3[i], int(x), int(y));
			break;
	}
}

bool _enemy::collided_with_player()
{
	if ((x + 25 > player.x) && (x < player.x + 25))
	{
		if ((y + 25 > player.y) && (y < player.y + 25))
		{
			return true;
		}
	}
	return false;
}

bool _enemy::was_shot()
{
	list<_shot>::iterator it;
	it = player.pshot.begin();
	while (it != player.pshot.end())
	{
		if ((x + 25 > (*it).x) && (x < (*it).x + 5))
		{
			if ((y + 25 > (*it).y) && (y < (*it).y + 7))
			{
				it = player.pshot.erase(it);
				it--;
				return true;
			}
		}
		it++;
	}
	return false;
}

void new_enemy(int type)
{
	_enemy e;
	e.init(type);
	enemies.push_back(e);
}

void new_enemy_group(int type, int num, int delay)
{
	int a, i, p = 0;
	float x = 0, y = 0;
	_enemy e;
	
	
	switch (type)
	{
		case ECIRCLE:
			a = rand()%2;
			if (a == 0)
			{
				p = STRAFERIGHT;
				x = 40 + rand()%200;
				y = -20;
			}
			else
			{
				p = STRAFELEFT;
				x = 400 + rand()%200;
				y = -20;
			}
			break;
	}
	
	i = 0;
	while (i < num)
	{
		e.init(type, x, y, p, delay * i);
		enemies.push_back(e);
		i++;
	}
}

void do_enemies()
{
	list<_enemy>::iterator it;
	list<_shot>::iterator sit;
	
	it = enemies.begin();
	while (it != enemies.end())
	{
		(*it).do_stuff();
		
		if (((*it).x < -50) || ((*it).x > 690) || ((*it).y < -50) || ((*it).y > 490))
		{
			(*it).exists = false;
		}
		
		if (!(*it).exists)
		{
			it = enemies.erase(it);
			it--;
		}
		it++;
	}
	
	sit = eshot.begin();
	while (sit != eshot.end())
	{
		(*sit).move();
		if (player.insane)
		{
			buffer_draw_sprite(eshot1[CRAZY], int((*sit).x), int((*sit).y));
		}
		else
		{
			buffer_draw_sprite(eshot1[SANE], int((*sit).x), int((*sit).y));
		}
		if (((*sit).x + 7 > player.x) && ((*sit).x < player.x + 25))
		{
			if (((*sit).y + 7 > player.y) && ((*sit).y < player.y + 25))
			{
				player.take_damage(8);
				new_particle(P_EXPLODE, int((*sit).x), int((*sit).y), (*sit).xv, (*sit).yv);
				sit = eshot.erase(sit);
				sit--;
			}
		}
		else if (((*sit).x < -50) || ((*sit).x > 690) || ((*sit).y < -50) || ((*sit).y > 490))
		{
			sit = eshot.erase(sit);
			sit--;
		}
		
		sit++;
	}
}
